from BaseClasses import Region

from ..base_classes import Q1Level


class e4m4(Q1Level):
    name = "The Palace of Hate"
    mapfile = "e4m4"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Shells (1)",
            "classname": "item_shells",
            "uuid": 10748123877522821978,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 13948221278058534738,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 4352076632090265969,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 3696146378582528782,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 8228188152649855837,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Large Medkit (6)",
            "classname": "item_health",
            "uuid": 7726851087762848744,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Small Medkit (7)",
            "classname": "item_health",
            "uuid": 13170464917113538435,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Small Medkit (8)",
            "classname": "item_health",
            "uuid": 12787708146115579187,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 14097277845391396766,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Small Medkit (10)",
            "classname": "item_health",
            "uuid": 12639801438325064831,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Shells (11)",
            "classname": "item_shells",
            "uuid": 16441560506403505505,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Spikes (12)",
            "classname": "item_spikes",
            "uuid": 9773145809190457227,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 10700185373750625287,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 14795650467560928624,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Shells (15)",
            "classname": "item_shells",
            "uuid": 8745599030178261893,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 16574083321195415867,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Spikes (17)",
            "classname": "item_spikes",
            "uuid": 2974054234901373659,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Shells (18)",
            "classname": "item_shells",
            "uuid": 17860619030642482835,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 16523434897345242164,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Green Armor (20)",
            "classname": "item_armor1",
            "uuid": 2323017694977803190,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Spikes (21)",
            "classname": "item_spikes",
            "uuid": 10585449553778611060,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Large Medkit (22)",
            "classname": "item_health",
            "uuid": 10701447135770956878,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Shells (23)",
            "classname": "item_shells",
            "uuid": 18197976403330937550,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Spikes (24)",
            "classname": "item_spikes",
            "uuid": 5085558403307661557,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 604219254350133228,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 14718491209863908392,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 8410929982999097886,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 4998481739685354559,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Rockets (29)",
            "classname": "item_rockets",
            "uuid": 3858545749220843782,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 7062184220134221335,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Spikes (31)",
            "classname": "item_spikes",
            "uuid": 7338166302766748402,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 6990107484488497580,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Rockets (33)",
            "classname": "item_rockets",
            "uuid": 9747382976974565250,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 12411694513129247809,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 13890910870019580991,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 388074638504555757,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Small Medkit (37)",
            "classname": "item_health",
            "uuid": 1502349162149158042,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 12837419766748229754,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 17448452064159947267,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 7725091960346996205,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 10873170902043574012,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Large Medkit (42)",
            "classname": "item_health",
            "uuid": 10477980155605366829,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Shells (43)",
            "classname": "item_shells",
            "uuid": 17978481173634994993,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Green Armor (44)",
            "classname": "item_armor1",
            "uuid": 15790517007124616246,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Silver Key (45)",
            "classname": "item_key1",
            "uuid": 1111067376695387592,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 17779970344033164663,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Shells (47)",
            "classname": "item_shells",
            "uuid": 13787949431419135977,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Shells (48)",
            "classname": "item_shells",
            "uuid": 6156852819029350412,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Shells (49)",
            "classname": "item_shells",
            "uuid": 11709166405143821149,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Rockets (50)",
            "classname": "item_rockets",
            "uuid": 15577814111394936591,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Spikes (51)",
            "classname": "item_spikes",
            "uuid": 6078822878024811529,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Megahealth (52)",
            "classname": "item_health",
            "uuid": 12504238317769587441,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Red Armor (53)",
            "classname": "item_armorInv",
            "uuid": 12289837740971115901,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Spikes (54)",
            "classname": "item_spikes",
            "uuid": 3369801644756342921,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Spikes (55)",
            "classname": "item_spikes",
            "uuid": 2207482206198730500,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 10826572173231790797,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 16588996295901080294,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Invulnerability (58)",
            "classname": "item_artifact_invulnerability",
            "uuid": 5460516444746310571,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Spikes (59)",
            "classname": "item_spikes",
            "uuid": 4033680152551185046,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Quad Damage (60)",
            "classname": "item_artifact_super_damage",
            "uuid": 1716713793250000645,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Rocketlauncher (61)",
            "classname": "weapon_rocketlauncher",
            "uuid": 13280939239052734812,
            "mp": 1,
        },
        {
            "id": 62,
            "name": "Supershotgun (62)",
            "classname": "weapon_supershotgun",
            "uuid": 728128438532514523,
            "mp": 1,
        },
        {
            "id": 63,
            "name": "Rocketlauncher (63)",
            "classname": "weapon_rocketlauncher",
            "uuid": 13813512395635423118,
            "mp": 1,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 2022069567224725747,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Spikes (65)",
            "classname": "item_spikes",
            "uuid": 4510269370107421569,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Shells (66)",
            "classname": "item_shells",
            "uuid": 13258932631704389638,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 12047795147832873155,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 8728045600775502006,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Shells (69)",
            "classname": "item_shells",
            "uuid": 17503490415769365938,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Secret (70)",
            "classname": "trigger_secret",
            "uuid": 2558644592881075591,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Secret (71)",
            "classname": "trigger_secret",
            "uuid": 16082239116904963863,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Secret (72)",
            "classname": "trigger_secret",
            "uuid": 16631303028043040049,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Supershotgun (73)",
            "classname": "weapon_supershotgun",
            "uuid": 18178173825463114981,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Grenadelauncher (74)",
            "classname": "weapon_grenadelauncher",
            "uuid": 11166087242289630653,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Grenadelauncher (75)",
            "classname": "weapon_grenadelauncher",
            "uuid": 6528401398922628429,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Supernailgun (76)",
            "classname": "weapon_supernailgun",
            "uuid": 14356512418270843513,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Nailgun (77)",
            "classname": "weapon_nailgun",
            "uuid": 5973781656982724551,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Lightning (78)",
            "classname": "weapon_lightning",
            "uuid": 15119158355978446809,
            "mp": 1,
        },
        {
            "id": 79,
            "name": "Biosuit (79)",
            "classname": "item_artifact_envirosuit",
            "uuid": 7067057266381972260,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Invisibility (80)",
            "classname": "item_artifact_invisibility",
            "uuid": 3060672351475239229,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Spikes (81)",
            "classname": "item_spikes",
            "uuid": 17318147993330950162,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Megahealth (82)",
            "classname": "item_health",
            "uuid": 14253904410462322858,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Cells (83)",
            "classname": "item_cells",
            "uuid": 13105813337751718477,
            "mp": 1,
        },
        {
            "id": 84,
            "name": "Cells (84)",
            "classname": "item_cells",
            "uuid": 1222663112256056850,
            "mp": 1,
        },
        {
            "id": 85,
            "name": "Cells (85)",
            "classname": "item_cells",
            "uuid": 13850522436659471465,
            "mp": 1,
        },
        {
            "id": 86,
            "name": "Invisibility (86)",
            "classname": "item_artifact_invisibility",
            "uuid": 3651536380275183351,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Invulnerability (87)",
            "classname": "item_artifact_invulnerability",
            "uuid": 12542090504768065564,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Grenadelauncher (88)",
            "classname": "weapon_grenadelauncher",
            "uuid": 2675054547175532647,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Lightning (89)",
            "classname": "weapon_lightning",
            "uuid": 2836627278330516865,
            "mp": 1,
        },
        {
            "id": 90,
            "name": "Cells (90)",
            "classname": "item_cells",
            "uuid": 7215131927755495456,
            "mp": 1,
        },
        {
            "id": 91,
            "name": "Invisibility (91)",
            "classname": "item_artifact_invisibility",
            "uuid": 6085427786574806815,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Nailgun (92)",
            "classname": "weapon_nailgun",
            "uuid": 16165148991561363791,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Shells (93)",
            "classname": "item_shells",
            "uuid": 6468025683375017100,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Cells (94)",
            "classname": "item_cells",
            "uuid": 5761513701995903627,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Cells (95)",
            "classname": "item_cells",
            "uuid": 15757100918402473314,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Cells (96)",
            "classname": "item_cells",
            "uuid": 10189648387716725523,
            "mp": 1,
        },
        {
            "id": 97,
            "name": "Lightning (97)",
            "classname": "weapon_lightning",
            "uuid": 3170505798792457932,
            "mp": 1,
        },
        {
            "id": 98,
            "name": "Grenadelauncher (98)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10865637112584225442,
            "mp": 1,
        },
        {
            "id": 99,
            "name": "Nailgun (99)",
            "classname": "weapon_nailgun",
            "uuid": 1192888007608505627,
            "mp": 1,
        },
        {
            "id": 100,
            "name": "Supershotgun (100)",
            "classname": "weapon_supershotgun",
            "uuid": 9848071362594956533,
            "mp": 1,
        },
        {
            "id": 101,
            "name": "Quad Damage (101)",
            "classname": "item_artifact_super_damage",
            "uuid": 17898779984331923236,
            "mp": 1,
        },
        {
            "id": 102,
            "name": "Supernailgun (102)",
            "classname": "weapon_supernailgun",
            "uuid": 9151941885567545953,
            "mp": 1,
        },
        {
            "id": 103,
            "name": "Nailgun (103)",
            "classname": "weapon_nailgun",
            "uuid": 7897308230782264292,
            "mp": 1,
        },
        {
            "id": 104,
            "name": "Small Medkit (104)",
            "classname": "item_health",
            "uuid": 16042793679165143414,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Spikes (105)",
            "classname": "item_spikes",
            "uuid": 11391477873830879156,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Spikes (106)",
            "classname": "item_spikes",
            "uuid": 11903662409943946889,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Spikes (107)",
            "classname": "item_spikes",
            "uuid": 18139890307732922161,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Shells (108)",
            "classname": "item_shells",
            "uuid": 533408396368542716,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Shells (109)",
            "classname": "item_shells",
            "uuid": 15075955245261702701,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Shells (110)",
            "classname": "item_shells",
            "uuid": 13540940609353715228,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Secret (111)",
            "classname": "trigger_secret",
            "uuid": 9829615769088473061,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Spikes (112)",
            "classname": "item_spikes",
            "uuid": 15399801097338620334,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Spikes (113)",
            "classname": "item_spikes",
            "uuid": 2512511129205146399,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Large Medkit (114)",
            "classname": "item_health",
            "uuid": 3628043098701502615,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Invisibility (115)",
            "classname": "item_artifact_invisibility",
            "uuid": 6858551502769820628,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Secret (116)",
            "classname": "trigger_secret",
            "uuid": 14450106905492915792,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Green Armor (117)",
            "classname": "item_armor1",
            "uuid": 9375051552422501337,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "All Kills (118)",
            "classname": "all_kills",
            "uuid": 11842292122861975710,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Megahealth (82)",
                "Shells (43)",
                "Supershotgun (73)",
                "Shells (15)",
                "Large Medkit (9)",
                "Shells (64)",
                "Shells (109)",
                "Small Medkit (10)",
                "Spikes (17)",
                "Spikes (16)",
                "Spikes (106)",
                "Supershotgun (62)",
                "Green Armor (20)",
                "Shells (48)",
                "Spikes (67)",
                "Shells (93)",
                "Large Medkit (28)",
                "Shells (66)",
                "Shells (49)",
                "Lightning (89)",
                "Shells (11)",
                "Small Medkit (7)",
                "Grenadelauncher (98)",
                "Green Armor (44)",
                "Supershotgun (100)",
                "Spikes (13)",
                "Nailgun (92)",
                "Spikes (12)",
                "Quad Damage (101)",
                "Small Medkit (8)",
                "Large Medkit (14)",
                "Nailgun (99)",
                "Shells (69)",
                "Shells (18)",
                "Nailgun (103)",
                "Small Medkit (19)",
                "Nailgun (77)",
                "Shells (108)",
                "Spikes (107)",
                "Spikes (81)",
                "Large Medkit (22)",
                "Spikes (21)",
                "Shells (23)",
                "Grenadelauncher (75)",
                "Rocketlauncher (61)",
                "Invisibility (80)",
                "Rockets (33)",
                "Cells (85)",
                "Large Medkit (34)",
                "Spikes (113)",
                "Large Medkit (42)",
                "Biosuit (79)",
                "Shells (47)",
                "Cells (84)",
                "Large Medkit (39)",
                "Spikes (112)",
                "Shells (40)",
                "Large Medkit (41)",
                "Spikes (25)",
                "Spikes (24)",
                "Shells (110)",
                "Grenadelauncher (74)",
                "Shells (46)",
                "Large Medkit (2)",
                "Large Medkit (5)",
                "Secret (111)",
                "Large Medkit (57)",
                "Large Medkit (3)",
                "Large Medkit (56)",
                "Large Medkit (6)",
                "Large Medkit (4)",
                "Shells (1)",
                "Spikes (26)",
                "Large Medkit (27)",
                "Invisibility (91)",
                "Rockets (50)",
                "Cells (90)",
                "Spikes (51)",
                "Secret (72)",
                "Red Armor (53)",
                "Lightning (97)",
                "Secret (71)",
                "Grenadelauncher (88)",
                "Invulnerability (58)",
                "Spikes (59)",
            ],
        )
        self.restrict("Secret (71)", r.can_shootswitch)
        self.restrict("Grenadelauncher (88)", r.can_shootswitch)
        self.restrict("Invulnerability (58)", r.can_shootswitch)
        self.restrict("Spikes (59)", r.can_shootswitch)

        past_door_area = self.region(
            "Past Door",
            [
                "Secret (70)",
                "Quad Damage (60)",
                "Small Medkit (104)",
                "Spikes (105)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        dive_area = self.region(
            "Dive Area",
            [
                "Spikes (31)",
                "Rockets (29)",
                "Large Medkit (35)",
                "Cells (96)",
                "Cells (94)",
                "Lightning (78)",
                "Cells (95)",
                "Large Medkit (30)",
                "Spikes (32)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Exit",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)

        lake_middle_platform_area = self.region(
            "Lake Middle Platform",
            [
                "Supernailgun (76)",
            ],
        )
        self.connect(ret, lake_middle_platform_area, r.jump)

        lake_platform_door_area = self.region(
            "Lake Platform Past Door",
            [
                "Spikes (54)",
                "Invisibility (86)",
                "Megahealth (52)",
                "Spikes (55)",
            ],
        )
        self.connect(lake_middle_platform_area, lake_platform_door_area, r.can_door)

        lake_side_area = self.region(
            "Lake Side Area",
            [
                "Large Medkit (36)",
                "Shells (38)",
                "Cells (83)",
                "Small Medkit (37)",
                "Silver Key (45)",
                "Invulnerability (87)",
            ],
        )
        self.connect(
            lake_middle_platform_area,
            lake_side_area,
            r.can_gj_extr | r.can_rj_hard | (r.can_button & r.jump),
        )

        lake_side_secret = self.region(
            "Lake Side Secret",
            [
                "Secret (116)",
                "Large Medkit (114)",
                "Invisibility (115)",
            ],
        )
        self.connect(
            lake_side_area, lake_side_secret, r.can_gj_med | r.can_rj_med | r.bigjump
        )

        past_ending_door = self.region(
            "Past Ending Door",
            [
                "Rocketlauncher (63)",
                "Spikes (65)",
                "Supernailgun (102)",
                "Green Armor (117)",
                "All Kills (118)",
            ],
        )
        self.connect(ret, past_ending_door, r.can_door)
        self.connect(lake_side_secret, past_ending_door)

        # dive for fish kills
        # TODO: could also be done without swimming in extreme difficulty maybe
        self.restrict(
            "All Kills (118)", r.can_dive & r.can_shootswitch & r.difficult_combat
        )

        return ret
